﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_Whodas_s : BaseTBIInstrumentPage
{

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 33; // Database Id for World Health Organization Disability Assessment Schedule 2.0 - Self

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_Whodas_s()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "Whodas-s.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew)
                {
                    SetUpSurvey(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("Whodas-s.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        }
        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        LabelDate1.Text = GetQuestionText("D");
        LabelForS1.Text = GetQuestionText("S1");
        LabelForS2.Text = GetQuestionText("S2");
        LabelForS3.Text = GetQuestionText("S3");
        LabelForS4.Text = GetQuestionText("S4");
        LabelForS5.Text = GetQuestionText("S5");
        LabelForS6.Text = GetQuestionText("S6");
        LabelForS7.Text = GetQuestionText("S7");
        LabelForS8.Text = GetQuestionText("S8");
        LabelForS9.Text = GetQuestionText("S9");
        LabelForS10.Text = GetQuestionText("S10");
        LabelForS11.Text = GetQuestionText("S11");
        LabelForS12.Text = GetQuestionText("S12");
        LabelForH1.Text = GetQuestionText("H1");
        LabelForH2.Text = GetQuestionText("H2");
        LabelForH3.Text = GetQuestionText("H3");
        dpDate1.MaxDate = DateTime.Now;

        lblSurveyError.Visible = false;
    }


    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }
        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("Whodas-s.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e) {
        if (PanelInstructions.Visible) {
            PanelInstructions.Visible = false;
            lnkBtnToggleInstructions.Text = "Click for Instructions";
        } else {
            PanelInstructions.Visible = true;
            lnkBtnToggleInstructions.Text = "Hide Instructions";
        }
    }


    #endregion


    #region Private Methods


    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();

        if (Page.IsValid)
        {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("Whodas-s.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("Whodas-s.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("Whodas-s.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
        else
        {
            lblSurveyError.Visible = true;
        }
    }


    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

        //Delete all the survey results from database if there are any.
        SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
        _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);
        

        // Question DX
        _surveyResult = new SURVEY_RESULT();
        try
        {
            // Add Question DX choice
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
            _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question DX");
        }

        // Question D
        _surveyResult = new SURVEY_RESULT();
        if (dpDate1.SelectedDate != null)
        {
            STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question DTE choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question D");
            }
        }
        
        // Question S1
        STD_QUESTION questionS1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S1");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS1.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS1.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S1");
        }

        // Question S2
        STD_QUESTION questionS2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S2");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS2.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS2.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S2");
        }
        
        // Question S3
        STD_QUESTION questionS3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S3");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS3.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS3.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S3");
        }
        
        // Question S4
        STD_QUESTION questionS4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S4");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS4.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS4.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S4");
        }

        // Question S5
        STD_QUESTION questionS5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S5");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS5.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS5.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S5");
        }
        
        // Question S6
        STD_QUESTION questionS6 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S6");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS6.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS6.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S6");
        }
        
        // Question S7
        STD_QUESTION questionS7 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S7");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS7.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS7.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S7");
        }

        // Question S8
        STD_QUESTION questionS8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S8");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS8.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS8.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S8");
        }

        // Question S9
        STD_QUESTION questionS9 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S9");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS9.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS9.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S9");
        }

        // Question S10
        STD_QUESTION questionS10 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S10");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS10.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS10.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S10");
        }

        // Question S11
        STD_QUESTION questionS11 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S11");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS11.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS11.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S11");
        }
        
        // Question S12
        STD_QUESTION questionS12 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S12");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS12.SelectedValue);
            _surveyResult.RESULT_TEXT = rblS12.SelectedItem.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question S12");
        }

        // Question H1
        STD_QUESTION questionH1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H1");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = questionH1.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = txtH1.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question H1");
        }

        // Question H2
        STD_QUESTION questionH2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H2");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = questionH2.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = txtH2.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question H2");
        }

        // Question H3
        STD_QUESTION questionH3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H3");
        _surveyResult = new SURVEY_RESULT();
        try
        {
            _surveyResult.STD_QUESTION_CHOICE_ID = questionH3.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            _surveyResult.RESULT_TEXT = txtH3.Text;
            survey.SURVEY_RESULTs.Add(_surveyResult);
        }
        catch (Exception surveyEx)
        {
            Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-s.aspx", "100027", "SaveSurvey() - Question H3");
        }

    }// END SaveSurvey



    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        int months = 0;
        int years = 0;
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                            {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        }
                        else
                        {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    case "D":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                                dpDate1.SelectedDate = temp;
                            }
                        }
                        break;
                    case "S1":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS1.SelectedIndex = -1;
                        }
                        break;
                    case "S2":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS2.SelectedIndex = -1;
                        }
                        break;
                    case "S3":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS3.SelectedIndex = -1;
                        }
                        break;
                    case "S4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS4.SelectedIndex = -1;
                        }
                        break;
                    case "S5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS5.SelectedIndex = -1;
                        }
                        break;
                    case "S6":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS6.SelectedIndex = -1;
                        }
                        break;
                    case "S7":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS7.SelectedIndex = -1;
                        }
                        break;
                    case "S8":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS8.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS8.SelectedIndex = -1;
                        }
                        break;
                    case "S9":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS9.SelectedIndex = -1;
                        }
                        break;
                    case "S10":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS10.SelectedIndex = -1;
                        }
                        break;
                    case "S11":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS11.SelectedIndex = -1;
                        }
                        break;
                    case "S12":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS12.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS12.SelectedIndex = -1;
                        }
                        break;
                    case "H1":
                        txtH1.Text = sResult.RESULT_TEXT;
                        break;
                    case "H2":
                        txtH2.Text = sResult.RESULT_TEXT;
                        break;
                    case "H3":
                        txtH3.Text = sResult.RESULT_TEXT;
                        break;                    
                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "Whodas-s.aspx", "100027", "SetUpSurvey()");
        }
    }
    // END SetUpSurvey

    #endregion
}
